.\" Copyright (c) 1999, Oracle and/or its affiliates.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbLibraryVersion __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbLibraryVersion \-  Determines the compatibility of a library at runtime.
.SH SYNOPSIS
.HP
.B Bool XkbLibraryVersion
.BI "(\^int *" "lib_major_in_out" "\^,"
.BI "int *" "lib_minor_in_out" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I lib_major_in_out
Specifies and returns the major Xkb library version.
.TP
.I lib_minor_in_out
Specifies and returns the minor Xkb library version.
.SH DESCRIPTION
.LP
If an application is dynamically linked, both the X server and the client-side X
library must contain the Xkb extension in order for the client to use the Xkb
extension capabilities. Therefore a dynamically linked application must check
both the library and the server for compatibility before using Xkb function
calls. A properly written program must check for compatibility between the
version of the Xkb library that is dynamically loaded and the one used when the
application was built. It must then check the server version for compatibility
with the version of Xkb in the library.

If your application is statically linked, you must still check for server
compatibility and may check library compatibility. (It is possible to compile
against one set of header files and link against a different, incompatible,
version of the library, although this should not normally occur.)

Pass the symbolic value XkbMajorVersion in
.I lib_major_in_out
and XkbMinorVersion in
.I lib_minor_in_out.
These arguments represent the version of the library used
at compile time. The
.I XkbLibraryVersion
function backfills the major and minor version numbers of the library used at
run time in
.I lib_major_in_out and
.I lib_minor_in_out.
If the versions of the compile time and run time libraries are
compatible,
.I XkbLibraryVersion
returns True, otherwise, it returns False.

In addition, in order to use the Xkb extension, you must ensure that the
extension is present in the server and that the server supports the version of
the extension expected by the client. Use
.I XkbQueryExtension
to do this, as described in the next section.
.SH "RETURN VALUES"
.TP 15
True
The
.I XkbLibraryVersion
returns True if the versions of the compile time and run time libraries are
compatible.
.TP 15
False
The
.I XkbLibraryVersion
returns False if the versions of the compile time and run time libraries are not
compatible.
.SH "SEE ALSO"
.BR XkbMajorVersion (__libmansuffix__),
.BR XkbMinorVersion (__libmansuffix__),
.BR XkbQueryExtension (__libmansuffix__)
